import { z, ZodTypeAny } from "zod"

function INTERNAL__createAttributeSchema<TName extends ZodTypeAny = ZodTypeAny, TValue extends ZodTypeAny = ZodTypeAny>(name: TName, value: TValue) {
  return z.object({
    Name: name,
    Value: value,
  })
}

function INTERNAL__createAttributeSchemaFromName<TName extends string = string, TValue extends ZodTypeAny = ZodTypeAny>(name: TName, value: TValue) {
  return INTERNAL__createAttributeSchema(z.literal(name), value)
}

const emailAttributeSchema = INTERNAL__createAttributeSchemaFromName('email', z.string());
const subAttributeSchema = INTERNAL__createAttributeSchemaFromName('sub', z.string());
const emailVerifiedAttributeSchema = INTERNAL__createAttributeSchemaFromName('email_verified', z.union([z.literal('true'), z.literal('false')]));
// const unknownAttributeSchema = INTERNAL__createAttributeSchema(z.string(), z.string())

const potentialAttributeSchema = z.union([
  subAttributeSchema,
  emailAttributeSchema,
  emailVerifiedAttributeSchema,
  // unknownAttributeSchema,
])

const attributesSchema = z.array(potentialAttributeSchema)

const userStatusSchema = z.union([
  z.literal("UNCONFIRMED"),
  z.literal("CONFIRMED"),
  z.literal("EXTERNAL_PROVIDER"),
  z.literal("UNKNOWN"),
  z.literal("RESET_REQUIRED"),
  z.literal("FORCE_CHANGE_PASSWORD"),
])

const userSchema = z.object({
  Attributes: attributesSchema,
  Enabled: z.boolean(),
  UserCreateDate: z.string(),
  UserLastModifiedDate: z.string(),
  UserStatus: userStatusSchema,
  Username: z.string()
})

export const userResultSchema = z.object({
  $metadata: z.object({
    httpStatusCode: z.number(),
    requestId: z.string(),
    attempts: z.number(),
    totalRetryDelay: z.number()
  }),
  Users: z.array(userSchema),
})

export const listUsersResultSchema = z.object({
  admin: userResultSchema,
  viewer: userResultSchema,
})

export type AppListUserResult = z.infer<typeof listUsersResultSchema>
export type AppUser = z.infer<typeof userSchema>

